﻿-- ==========================================
-- Type: Procedures
-- Name: [dbo].[ACT_PDC_ACTION]
-- Exported on: 10/31/2025 05:27:20
-- ==========================================

CREATE   PROCEDURE [dbo].[ACT_PDC_ACTION]
	@action VARCHAR(255),
	@params ParamTableType READONLY
AS
BEGIN
	SET NOCOUNT ON;

-- #region Definitions
	-- Üzenet változók
	DECLARE @errmsg NVARCHAR(255) = '';
	DECLARE @successmsg NVARCHAR(255) = '';

	DECLARE @sess_userId NVARCHAR(254) = (SELECT [Value] FROM @params WHERE [Name] = '$User.id');
	DECLARE @language NVARCHAR(10) = (SELECT [Value] FROM @params WHERE [Name] = '$Language.code'); -- hu_HU, en_GB, stb.
	DECLARE @technicianName NVARCHAR(254) = (SELECT CONCAT(lastName, ' ', firstName) FROM OHEM WHERE empID = @sess_userId);
	DECLARE @technicianWHS NVARCHAR(50) = (SELECT U_ACT_Whs FROM OHEM WHERE empID = @sess_userId);

-- #endregion

-- #region Session handling
	IF @action = 'Session_Read'
	BEGIN
		DECLARE @session_read_id NVARCHAR(255) = (SELECT [Value] FROM @params WHERE [Name] = 'Session.id');
		DECLARE @session_read_name NVARCHAR(255) = (SELECT [Value] FROM @params WHERE [Name] = 'Session.name');

		UPDATE [@ACT_PDC_SESSIONS] SET [data] = NULL, [status] = NULL, [userId] = NULL WHERE [name] = @session_read_name AND [id] = @session_read_id AND [status] = 'D';

		SELECT [data] AS [Data] FROM [@ACT_PDC_SESSIONS] WHERE [name] = @session_read_name AND [id] = @session_read_id;

	END

	IF @action = 'Session_Write'
	BEGIN

		DECLARE @session_write_id NVARCHAR(255) = (SELECT [Value] FROM @params WHERE [Name] = 'Session.id');
		DECLARE @session_write_name NVARCHAR(255) = (SELECT [Value] FROM @params WHERE [Name] = 'Session.name');
		DECLARE @session_write_data NVARCHAR(MAX) = (SELECT [Value] FROM @params WHERE [Name] = 'Session.data');

		DECLARE @session_write_read_id NVARCHAR(255);
		SELECT
			@session_write_read_id = [id]
		FROM [@ACT_PDC_SESSIONS] WHERE [name] = @session_write_name AND [id] = @session_write_id;

		IF @session_write_read_id IS NOT NULL
		BEGIN
			UPDATE [@ACT_PDC_SESSIONS] SET [data] = @session_write_data WHERE [name] = @session_write_name AND [id] = @session_write_id;
		END
		ELSE
		BEGIN
			INSERT INTO [@ACT_PDC_SESSIONS] ([name], [id], [data]) VALUES(@session_write_name, @session_write_id, @session_write_data);
		END

	END

	IF @action = 'Session_Destroy'
	BEGIN

		DECLARE @session_destroy_id NVARCHAR(255) = (SELECT [Value] FROM @params WHERE [Name] = 'Session.id');
		DECLARE @session_destroy_name NVARCHAR(255) = (SELECT [Value] FROM @params WHERE [Name] = 'Session.name');

		DELETE FROM [@ACT_PDC_SESSIONS] WHERE [name] = @session_destroy_name AND [id] = @session_destroy_id;

	END

	IF @action = 'Session_GC'
	BEGIN

		DECLARE @session_gc_lifetime INT = (SELECT [Value] FROM @params WHERE [Name] = 'Lifetime');
		DECLARE @session_gc_name NVARCHAR(255) = (SELECT [Value] FROM @params WHERE [Name] = 'Session.name');

		DECLARE @session_gc_gcCount INT;

		DELETE FROM [@ACT_PDC_SESSIONS] WHERE [name] = @session_gc_name AND [modificationDate] < DATEADD(SECOND, @session_gc_lifetime, GETDATE());
		SET @session_gc_gcCount = @@ROWCOUNT;

		SELECT 'Results' AS [Section];
		SELECT @session_gc_gcCount AS [GC_Count];

	END
-- #endregion

-- #region Install
	IF @action = 'Install'
	BEGIN
		CREATE TABLE [@ACT_PDC_SESSIONS] (
			[name] [nvarchar](255) NULL,
			[id] [nvarchar](255) NULL,
			[data] [ntext] NULL,
			[creationDate] [datetime] NULL,
			[modificationDate] [datetime] NULL,
			[status] [char](1) NULL,
			[userId] [int] NULL
		);
	END
-- #endregion

-- #region Login
	-- Bejelentkezés
	IF @action = 'login'
	BEGIN

		DECLARE @login_userCode NVARCHAR(254) = (SELECT [Value] FROM @params WHERE [Name] = 'EmpCode');

		DECLARE @login_empId INT = (SELECT t0.empID FROM [OHEM] t0 WHERE t0.[ExtEmpNo] = @login_userCode);

		SELECT 'LoginData' AS [Section];
		SELECT
			t0.*,
			(CASE
				WHEN (SELECT COUNT(*) FROM HEM6 t00 LEFT JOIN OHTY t01 ON t00.roleID = t01.typeID WHERE t00.empID = t0.empID AND t01.name = 'Admin') > 0 THEN '/dwsselection'
				WHEN (SELECT COUNT(*) FROM HEM6 t00 LEFT JOIN OHTY t01 ON t00.roleID = t01.typeID WHERE t00.empID = t0.empID AND t01.name IN ('Dolgozó')) > 1 THEN '/dwsselection'
				ELSE '/dwsselection'
			END) AS [HomeURL],
			CASE WHEN ISNULL(t0.U_ACT_Language, '') = '' THEN 'hu_HU' ELSE t0.U_ACT_Language END AS [Language]
		FROM [OHEM] t0 WHERE t0.[ExtEmpNo] = @login_userCode;

		IF @@ROWCOUNT = 0
		BEGIN
			SET @errmsg = (SELECT TEXT FROM ACT_PDC_Dictionary WHERE LanguageCode = @language AND TextCode = 'employee_not_found');
		END
		ELSE
		BEGIN

			-- SELECT 'Permissions' AS [Section];
			-- SELECT 'admin.home' AS [Permission];

			DECLARE @login_session_id NVARCHAR(254) = (SELECT [Value] FROM @params WHERE [Name] = '$Session.id');
			DECLARE @login_session_name NVARCHAR(254) = (SELECT [Value] FROM @params WHERE [Name] = '$Session.name');

			--szükség van a párhuzamos munkavégzésre egy felhasználóval, ezért nem töröljük a sessiont.
			--UPDATE [@ACT_PDC_SESSIONS] SET status = 'D' WHERE userId = @login_empId;

			UPDATE [@ACT_PDC_SESSIONS] SET userId = @login_empId WHERE name = @login_session_name AND id = @login_session_id;

			SET @successmsg = (SELECT TEXT FROM ACT_PDC_Dictionary WHERE LanguageCode = @language AND TextCode = 'succesful_login');
		END

	END
-- #endregion

-- #region Logout
	IF @action = 'Logout'
	BEGIN

		DECLARE @session_id NVARCHAR(254) = (SELECT [Value] FROM @params WHERE [Name] = '$Session.id');
		DECLARE @session_name NVARCHAR(254) = (SELECT [Value] FROM @params WHERE [Name] = '$Session.name');

		UPDATE [@ACT_PDC_SESSIONS] SET status = 'D' WHERE name = @session_name AND id = @session_id;

		SET @successmsg = (SELECT TEXT FROM ACT_PDC_Dictionary WHERE LanguageCode = @language AND TextCode = 'logged_out');

	END
-- #endregion

-- #region CmdRun
	IF @action = 'ConfirmGenerate'
	BEGIN
		DECLARE @noSignature NVARCHAR(254) = (SELECT [Value] FROM @params WHERE [Name] = 'NoSignature');
		DECLARE @ticketId_confirm NVARCHAR(254) = (SELECT [Value] FROM @params WHERE [Name] = 'Id');

		--0 mennyiségű vagy üres cikkszámú sorok törlése
		DELETE FROM [@ACT_DWS_ITEMS] WHERE (U_Quantity = 0 OR ISNULL(U_ItemCode,'') = '') and U_CallId = @ticketId_confirm
		--vizsgálat, hogy a sorozatszámos cikkeknél lett-e választva sorozatszám
		IF EXISTS(SELECT * FROM [@ACT_DWS_ITEMS] t1 INNER JOIN OITM t2 ON (t1.U_ItemCode = t2.ItemCode) 
		WHERE t1.U_CallId = @ticketId_confirm AND ISNULL(t1.U_SerialNumber, '') = '' AND t2.ManSerNum = 'Y' AND U_OpButton <> 1)
		BEGIN
			SET @errmsg = (SELECT TEXT FROM ACT_PDC_Dictionary WHERE LanguageCode = @language AND TextCode = 'serial_choose_mandatory');
			GOTO ProcEnd;
		END

		--vizsgálat, hogy többször is választotta-e ugyanazt a sorozatszámot
		IF EXISTS(SELECT t1.U_SerialNumber, count(*) as Qty FROM [@ACT_DWS_ITEMS] t1
		WHERE t1.U_CallId = @ticketId_confirm AND ISNULL(t1.U_SerialNumber, '') <> '' AND U_OpButton <> 1
		GROUP BY U_SerialNumber
		HAVING count(*) > 1)
		BEGIN
			SET @errmsg = (SELECT TEXT FROM ACT_PDC_Dictionary WHERE LanguageCode = @language AND TextCode = 'same_serial_error');
			GOTO ProcEnd;
		END

		IF @noSignature = 'true' AND (SELECT U_NotPresent FROM OSCL WHERE callID = @ticketId_confirm) = 'N'
		BEGIN
			SET @errmsg = (SELECT TEXT FROM ACT_PDC_Dictionary WHERE LanguageCode = @language AND TextCode = 'no_signature');
			GOTO ProcEnd;
		END
		
		
		SET @errmsg = (SELECT TEXT FROM ACT_PDC_Dictionary WHERE LanguageCode = @language AND TextCode = 'please_confirm');
		
	END

	IF @action = 'CmdRun'
	BEGIN
		DECLARE @command_Name NVARCHAR(254) = (SELECT [Value] FROM @params WHERE [Name] = 'Command');

		IF @command_Name IN ('generateCrystalReport', 'previewCrystalReport')
		BEGIN
			DECLARE @empty_file NVARCHAR(254) = 'c:\SAPB1\SAPB1_SHR\Tools\empty.jpg';
			DECLARE @command_Arg0 NVARCHAR(254) = (CASE WHEN ISNULL((SELECT [Value] FROM @params WHERE [Name] = 'Args.0'),'') = '' THEN @empty_file ELSE (SELECT [Value] FROM @params WHERE [Name] = 'Args.0') END); --fájl elérés pl.: C:\Windows\Temp\PDCB7AD.tmp
			DECLARE @command_Arg1 NVARCHAR(254) = (CASE WHEN ISNULL((SELECT [Value] FROM @params WHERE [Name] = 'Args.1'),'') = '' THEN @empty_file ELSE (SELECT [Value] FROM @params WHERE [Name] = 'Args.1') END); --fájl2 elérés pl.: C:\Windows\Temp\PDCB7AD.tmp
			DECLARE @command_Arg2 NVARCHAR(254) = (SELECT [Value] FROM @params WHERE [Name] = 'Args.2'); --tickedId, pl: 1
			SET @command_Arg0 = REPLACE(@command_Arg0, '\', '\\')
			SET @command_Arg1 = REPLACE(@command_Arg1, '\', '\\')
			SET @empty_file = REPLACE(@empty_file, '\', '\\')
			DECLARE @customer_language NVARCHAR(10) = (SELECT U_PrintingLang FROM OCRD t1 INNER JOIN OSCL t2 ON (T1.CardCode = t2.customer) WHERE t2.callID = @command_Arg2); 
			SET @customer_language = CASE WHEN ISNULL(@customer_language, 'HU') = 'HU' THEN 'hu_HU' ELSE 'en_GB' END

			IF @command_Name = 'generateCrystalReport'
			BEGIN
				DECLARE @docnum int = (SELECT DocNum FROM OSCL WHERE callID = @command_Arg2)

				--DECLARE @pdf_filename NVARCHAR(254) = CONCAT(@command_Arg2, '_', FORMAT(GETDATE(), 'yyyyMMdd_HHmmss'), '.pdf');
				DECLARE @pdf_filename NVARCHAR(254) = CONCAT(@docnum, '.pdf');
				DECLARE @command_generate NVARCHAR(MAX) = CONCAT( N'\\10.82.159.12\sapb1_shr\Tools\generate_report.bat "', @pdf_filename, N'" "', @command_Arg2, N'" "', @command_Arg0, N'" "', @command_Arg1, N'" "', @technicianName, N'" "', @customer_language, N'"');
			
				SELECT @command_generate AS [Alias];

				--aláírások mentése
				DECLARE @target_dir NVARCHAR(254) = 'c:\\SAPB1\\SAPB1_SHR\\Munkalapok\\Signatures';
				--SET @target_dir = REPLACE(@target_dir, '\', '\\');
				-- Arg0 mentése
				IF @command_Arg0 <> @empty_file
				BEGIN
					-- Kivágjuk a fájlnevet
					DECLARE @file_Name_arg0 NVARCHAR(255) = SUBSTRING(@command_Arg0, LEN('C:\\Windows\\Temp\\') + 1, CHARINDEX('.tmp', @command_Arg0) - LEN('C:\\Windows\\Temp\\') - 1);
					DECLARE @copy_cmd0 NVARCHAR(500) = CONCAT('copy "', @command_Arg0, '" "', @target_dir, '\\', @command_Arg2, '_', @file_Name_arg0, '_image0.jpg"');
				
				END
				-- Arg1 mentése
				IF @command_Arg1 <> @empty_file
				BEGIN
					-- Kivágjuk a fájlnevet
					DECLARE @file_Name_arg1 NVARCHAR(255) = SUBSTRING(@command_Arg0, LEN('C:\\Windows\\Temp\\') + 1, CHARINDEX('.tmp', @command_Arg1) - LEN('C:\\Windows\\Temp\\') - 1);
					DECLARE @copy_cmd1 NVARCHAR(500) = CONCAT('copy "', @command_Arg1, '" "', @target_dir, '\\', @command_Arg2, '_', @file_Name_arg1, '_image1.jpg"');
				END

				UPDATE OSCL
				SET U_FilePath = CONCAT('\\10.82.159.12\SAPB1_SHR\Munkalapok\',@pdf_filename),
					Status = 1
				WHERE callID = @command_Arg2;

				UPDATE [@ACT_CONNSRVC_ROW] SET U_Status = 'Befejezett' WHERE U_ID = @command_Arg2;

				--Az ajánlati sorokat töröltre állítja, ha a szervízhíváson az "Ajánlat szerint" nincs bepipálva
				UPDATE t1 SET t1.U_OpButton = 1
				FROM [@ACT_DWS_ITEMS] t1 INNER JOIN OSCL t2 ON (t1.U_CallId = t2.callID)
				WHERE t1.U_CallId = @command_Arg2 AND t1.U_Installed = 'Y' AND (t1.U_FromOffer = 'Y' AND t2.U_ByOffer = 'N') AND t1.U_OpButton = 0

				-- Bizonylattervezetek generálása
				EXEC ACT_CREATE_SERVICEDOCDRAFTS @command_Arg2

				-- E-mail küldése
				INSERT INTO DW_SEND (CreateTime, Ticket, Sended) SELECT GETDATE(), @pdf_filename, 'N'

			END

			IF @command_Name = 'previewCrystalReport'
			BEGIN
				DECLARE @pre_filename NVARCHAR(254) = CONCAT(@command_Arg2, '_', FORMAT(GETDATE(), 'yyyyMMdd_HHmmss'), '_Preview', '.pdf');
				SELECT CONCAT(N'\\10.82.159.12\sapb1_shr\Tools\CrystalReportsCLI\x64\Debug\CrystalReportsCLI.exe export "\\10.82.159.12\\sapb1_shr\\Tools\\Digitalis munkalap (Meltech).rpt" "\\10.82.159.12\\sapb1_shr\\Munkalapok\\', @pre_filename, N'" "{\"DocKey@\":\"',@command_Arg2, '\",\"Path1@\":\"', @command_Arg0, '\",\"Path2@\":\"', @command_Arg1, '\",\"Technician@\":\"', @technicianName, '\",\"Language@\":\"', @customer_language, '\",\"preview\":\"Y\"}"') AS [Alias];	
			END
		END

	END
-- #endregion

	IF @action = 'GetPrice'
	BEGIN
		DECLARE @getPrice_itemCode NVARCHAR(254) = (SELECT [Value] FROM @params WHERE [Name] = 'Cikkszam.id');
		DECLARE @getPrice_priceList NVARCHAR(254) = (SELECT [Value] FROM @params WHERE [Name] = 'Pricelist.id');
		DECLARE @getPrice_cardCode NVARCHAR(254) = (SELECT [Value] FROM @params WHERE [Name] = 'Cardcode.id');
		
		IF @getPrice_cardCode IS NULL
		BEGIN
 
			SELECT FORMAT(Price, '0.00', 'hu-HU') AS Price FROM ITM1 WHERE ItemCode = @getPrice_itemCode AND PriceList = @getPrice_priceList
 
		END
 
		IF @getPrice_cardCode IS NOT NULL
		BEGIN
 
			IF (SELECT COUNT(LINENUM) FROM SPP1 WHERE ItemCode = @getPrice_itemCode AND CardCode = @getPrice_cardCode) > 0
			BEGIN
 
				SELECT FORMAT(Price, '0.00', 'hu-HU') AS Price FROM SPP1 WHERE ItemCode = @getPrice_itemCode AND CardCode = @getPrice_cardCode AND CONVERT(date, GETDATE()) BETWEEN FromDate AND ISNULL(ToDate, '2099.12.31')
 
			END
 
			IF (SELECT COUNT(LINENUM) FROM SPP1 WHERE ItemCode = @getPrice_itemCode AND CardCode = @getPrice_cardCode) = 0
			BEGIN
 
				IF (SELECT COUNT(ItemCode) FROM OSPP WHERE ItemCode = @getPrice_itemCode AND CardCode = @getPrice_cardCode) > 0
				BEGIN
 
					SELECT FORMAT(Price, '0.00', 'hu-HU') AS Price FROM OSPP WHERE ItemCode = @getPrice_itemCode AND CardCode = @getPrice_cardCode
 
				END
 
				IF (SELECT COUNT(ItemCode) FROM OSPP WHERE ItemCode = @getPrice_itemCode AND CardCode = @getPrice_cardCode) = 0
				BEGIN
 
					SELECT FORMAT(Price, '0.00', 'hu-HU') AS Price FROM ITM1 WHERE ItemCode = @getPrice_itemCode AND PriceList = @getPrice_priceList
 
				END
 
			END
 
		END
	END


	IF @action = 'ChangeWarehouse'
	BEGIN
		DECLARE @changeWarehouse_rowCode NVARCHAR(254) = (SELECT [Value] FROM @params WHERE [Name] = 'Code');
		DECLARE @changeWarehouse_whsCode NVARCHAR(254) = (SELECT [Value] FROM @params WHERE [Name] = 'Warehouse.id');

		UPDATE [@ACT_DWS_ITEMS]
			SET U_WhsCode = @changeWarehouse_whsCode
		WHERE Code = @changeWarehouse_rowCode

	END

	IF @action = 'ChangeItem'
	BEGIN
		DECLARE @changeItem_rowCode NVARCHAR(254) = (SELECT [Value] FROM @params WHERE [Name] = 'Code');
		DECLARE @changeItem_itemCode NVARCHAR(254) = ISNULL((SELECT [Value] FROM @params WHERE [Name] = 'ItemCode.id'),'');

		UPDATE t1
			SET t1.U_ItemCode = @changeItem_itemCode,
				t1.U_SerialNumber = ''
		FROM [@ACT_DWS_ITEMS] t1
		WHERE t1.Code = @changeItem_rowCode
	END

	IF @action = 'ChangeSerialWithItem'
	BEGIN
		DECLARE @changeItemWithSerial_rowCode NVARCHAR(254) = (SELECT [Value] FROM @params WHERE [Name] = 'Code');
		DECLARE @changeItemWithSerial_serialNumber NVARCHAR(254) = ISNULL((SELECT [Value] FROM @params WHERE [Name] = 'SerialNumber.id'),'');

		UPDATE t1
			SET t1.U_ItemCode = t2.ItemCode,
				t1.U_SerialNumber = @changeItemWithSerial_serialNumber,
				t1.U_Quantity = 1
		FROM [@ACT_DWS_ITEMS] t1 INNER JOIN OSRN t2 ON (@changeItemWithSerial_serialNumber = t2.MnfSerial)
		WHERE t1.Code = @changeItemWithSerial_rowCode
	END

	IF @action = 'SetDismantledSerial'
	BEGIN
		DECLARE @setDismantledSerial_rowCode NVARCHAR(254) = (SELECT [Value] FROM @params WHERE [Name] = 'Code');
		DECLARE @setDismantledSerial_serialNumber NVARCHAR(254) = ISNULL((SELECT [Value] FROM @params WHERE [Name] = 'SerialNumber'),'');

		IF  @setDismantledSerial_serialNumber <> ''
		BEGIN
			UPDATE t1
				SET t1.U_SerialNumber = @setDismantledSerial_serialNumber,
					t1.U_Quantity = 1
			FROM [@ACT_DWS_ITEMS] t1 
			WHERE t1.Code = @setDismantledSerial_rowCode
		END
	END

	IF @action = 'SetQuantity'
	BEGIN
		DECLARE @setQuantity_rowCode NVARCHAR(254) = (SELECT [Value] FROM @params WHERE [Name] = 'Code');
		DECLARE @setQuantity_quantity NUMERIC(19,6) = REPLACE((SELECT [Value] FROM @params WHERE [Name] = 'Quantity'),',','.');
		DECLARE @setQuantity_onhand NUMERIC(19,6) = (SELECT t2.OnHand - ISNULL(T00.Qty,0) + ISNULL(T01.Qty,0) FROM [@ACT_DWS_ITEMS] t1 INNER JOIN OITM t2 ON (t1.U_ItemCode = t2.ItemCode) 
				LEFT JOIN (SELECT T6.ItemCode, SUM(T6.Quantity) AS Qty FROM OSCL T4 INNER JOIN ODRF T5 ON T4.U_ItemIn = T5.DocEntry INNER JOIN DRF1 T6 ON T5.DocEntry = T6.DocEntry
		WHERE ISNULL(T4.U_ItemIn, '') <> '' AND	T5.DocStatus = 'O' AND T6.WhsCode = @technicianWHS
		GROUP BY T6.ItemCode) T00 ON (T00.ItemCode = T2.ItemCode)
		LEFT JOIN (SELECT T6.ItemCode, SUM(T6.Quantity) AS Qty FROM OSCL T4 INNER JOIN ODRF T5 ON T4.U_ItemIn = T5.DocEntry INNER JOIN DRF1 T6 ON T5.DocEntry = T6.DocEntry
		WHERE ISNULL(T4.U_ItemOut, '') <> '' AND T5.DocStatus = 'O' AND T6.WhsCode = @technicianWHS
		GROUP BY T6.ItemCode) T01 ON (T01.ItemCode = T2.ItemCode)
		WHERE t1.Code = @setQuantity_rowCode)

		IF @setQuantity_quantity <= @setQuantity_onhand
		BEGIN
			UPDATE [@ACT_DWS_ITEMS]
				SET U_Quantity = @setQuantity_quantity
			WHERE Code = @setQuantity_rowCode
		END
		ELSE
		BEGIN
			SET @errmsg = CONCAT(@setQuantity_onhand, ' ', (SELECT TEXT FROM ACT_PDC_Dictionary WHERE LanguageCode = @language AND TextCode = 'items_exists'))
		END
		
	END

	IF @action = 'SetDismantledQuantity'
	BEGIN
		DECLARE @setDismantledQuantity_rowCode NVARCHAR(254) = (SELECT [Value] FROM @params WHERE [Name] = 'Code');
		DECLARE @setDismantledQuantity_quantity NUMERIC(19,6) = REPLACE((SELECT [Value] FROM @params WHERE [Name] = 'Quantity'),',','.');

		UPDATE [@ACT_DWS_ITEMS]
			SET U_Quantity = @setDismantledQuantity_quantity
		WHERE Code = @setDismantledQuantity_rowCode
		
	END

	IF @action = 'SetDescription'
	BEGIN
		DECLARE @setDescription_rowCode NVARCHAR(254) = (SELECT [Value] FROM @params WHERE [Name] = 'Code');
		DECLARE @setDescription_description NVARCHAR(254) = (SELECT [Value] FROM @params WHERE [Name] = 'Description');

		UPDATE [@ACT_DWS_ITEMS]
			SET U_Description = @setDescription_description
		WHERE Code = @setDescription_rowCode
	END

	IF @action = 'RowOperation'
	BEGIN
		DECLARE @rowOperation_rowCode NVARCHAR(254) = (SELECT [Value] FROM @params WHERE [Name] = 'Code');
		DECLARE @rowOperation_opButton INT = (SELECT U_OpButton FROM [@ACT_DWS_ITEMS] WHERE Code = @rowOperation_rowCode);
		DECLARE @rowOperation_installed NVARCHAR(254) = (SELECT U_Installed FROM [@ACT_DWS_ITEMS] WHERE Code = @rowOperation_rowCode);
		DECLARE @rowOperation_callId NVARCHAR(254) = (SELECT U_CallId FROM [@ACT_DWS_ITEMS] WHERE Code = @rowOperation_rowCode);

		IF @rowOperation_opButton = 0
		BEGIN
			--DELETE FROM [@ACT_DWS_ITEMS]
			--WHERE Code = @rowOperation_rowCode
			UPDATE [@ACT_DWS_ITEMS]
			SET U_OpButton = 1
			WHERE Code = @rowOperation_rowCode
		END
		/*ELSE IF @rowOperation_opButton = '1'
		BEGIN
			UPDATE [@ACT_DWS_ITEMS]
				SET U_OpButton = 0
			WHERE Code = @rowOperation_rowCode

			INSERT INTO [@ACT_DWS_ITEMS] (U_WhsCode, U_ItemCode, U_SerialNumber, U_Quantity, U_Description, U_Installed, U_FromOffer, U_CallId, U_OpButton)
			SELECT '', '', '', 0, '', @rowOperation_installed, 'N', @rowOperation_callId, 1
		END*/

	END


-- #region SaveTicket
	IF @action = 'SaveTicket'
	BEGIN
		DECLARE @iso_ticket_startDateTime NVARCHAR(254) = (SELECT [Value] FROM @params WHERE [Name] = 'MunkaMegkezdes');
		DECLARE @iso_ticket_endDateTime NVARCHAR(254) = (SELECT [Value] FROM @params WHERE [Name] = 'MunkaBefejezes');
		IF ISNULL(@iso_ticket_startDateTime, '') = ''
		BEGIN
			SET @errmsg = (SELECT TEXT FROM ACT_PDC_Dictionary WHERE LanguageCode = @language AND TextCode = 'work_start_mandatory');
			GOTO ProcEnd;
		END
		IF ISNULL(@iso_ticket_endDateTime, '') = ''
		BEGIN
			SET @errmsg = (SELECT TEXT FROM ACT_PDC_Dictionary WHERE LanguageCode = @language AND TextCode = 'work_end_mandatory');
			GOTO ProcEnd;
		END

		DECLARE @ticket_startDateTime DATETIME =  CAST((CAST(@iso_ticket_startDateTime AS DATETIMEOFFSET) AT TIME ZONE 'UTC' AT TIME ZONE 'Central European Standard Time') AS DATETIME);
		DECLARE @ticket_endDateTime DATETIME =  CAST((CAST(@iso_ticket_endDateTime AS DATETIMEOFFSET) AT TIME ZONE 'UTC' AT TIME ZONE 'Central European Standard Time') AS DATETIME);
		DECLARE @ticket_duration INT = DATEDIFF(SECOND, @ticket_startDateTime, @ticket_endDateTime);

		DECLARE @ticket_km NVARCHAR(254) = (SELECT [Value] FROM @params WHERE [Name] = 'Km');
		DECLARE @ticket_counter NVARCHAR(254) = (SELECT [Value] FROM @params WHERE [Name] = 'Szamlaloallas');
		DECLARE @ticket_location NVARCHAR(254) = (SELECT [Value] FROM @params WHERE [Name] = 'HelyiAzonosito');
		DECLARE @ticket_travelTime NVARCHAR(254) = (SELECT [Value] FROM @params WHERE [Name] = 'UtazasiIdo');
		DECLARE @ticket_description NVARCHAR(MAX) = (SELECT [Value] FROM @params WHERE [Name] = 'HibaLeiras');
		DECLARE @ticket_comingJobs NVARCHAR(MAX) = (SELECT [Value] FROM @params WHERE [Name] = 'EsedekesMunkak');
		DECLARE @ticket_bpeMail NVARCHAR(254) = (SELECT [Value] FROM @params WHERE [Name] = 'AtvevoEmail');
		DECLARE @ticket_recipient NVARCHAR(254) = (SELECT [Value] FROM @params WHERE [Name] = 'Atvevo');
		DECLARE @ticket_Id INT = (SELECT [Value] FROM @params WHERE [Name] = 'Id');
		DECLARE @ticket_byOffer NVARCHAR(254) = (SELECT [Value] FROM @params WHERE [Name] = 'AjanlatSzerint');
		DECLARE @ticket_byOfferChar NVARCHAR(1) = CASE WHEN @ticket_byOffer = 'true' THEN 'Y' ELSE 'N' END;
		DECLARE @ticket_notPresent NVARCHAR(254) = (SELECT [Value] FROM @params WHERE [Name] = 'NotAttended');
		DECLARE @ticket_notPresentChar NVARCHAR(1) = CASE WHEN @ticket_notPresent = 'true' THEN 'Y' ELSE 'N' END;
		
		DECLARE @ticket_guarantee NVARCHAR(254) = (SELECT [Value] FROM @params WHERE [Name] = 'Garancialis');
		DECLARE @ticket_guaranteetChar NVARCHAR(1) = CASE WHEN @ticket_guarantee = 'true' THEN 'Y' ELSE 'N' END;
		DECLARE @ticket_BPReferenceNumber NVARCHAR(254) = (SELECT [Value] FROM @params WHERE [Name] = 'BPReferenceNumber');

		--0 mennyiségű vagy üres cikkszámú sorok törlése
		DELETE FROM [@ACT_DWS_ITEMS] WHERE (U_Quantity = 0 OR ISNULL(U_ItemCode,'') = '') and U_CallId = @ticket_Id
		--vizsgálat, hogy a sorozatszámos cikkeknél lett-e választva sorozatszám
		IF EXISTS(SELECT * FROM [@ACT_DWS_ITEMS] t1 INNER JOIN OITM t2 ON (t1.U_ItemCode = t2.ItemCode) 
		WHERE t1.U_CallId = @ticket_Id AND ISNULL(t1.U_SerialNumber, '') = '' AND t2.ManSerNum = 'Y' AND U_OpButton <> 1)
		BEGIN
			SET @errmsg = (SELECT TEXT FROM ACT_PDC_Dictionary WHERE LanguageCode = @language AND TextCode = 'serial_choose_mandatory');
			GOTO ProcEnd;
		END

		--vizsgálat, hogy többször is választotta-e ugyanazt a sorozatszámot
		IF EXISTS(SELECT t1.U_SerialNumber, count(*) as Qty FROM [@ACT_DWS_ITEMS] t1
		WHERE t1.U_CallId = @ticket_Id AND ISNULL(t1.U_SerialNumber, '') <> '' AND U_OpButton <> 1
		GROUP BY U_SerialNumber
		HAVING count(*) > 1)
		BEGIN
			SET @errmsg = (SELECT TEXT FROM ACT_PDC_Dictionary WHERE LanguageCode = @language AND TextCode = 'same_serial_error');
			GOTO ProcEnd;
		END

		--kötelező mezők ellenőrzése
		IF @ticket_duration <= 0
		BEGIN
			SET @errmsg = (SELECT TEXT FROM ACT_PDC_Dictionary WHERE LanguageCode = @language AND TextCode = 'end_must_be_greater');
			GOTO ProcEnd;
		END
		IF ISNULL(@ticket_travelTime, '') = ''
		BEGIN
			SET @errmsg = (SELECT TEXT FROM ACT_PDC_Dictionary WHERE LanguageCode = @language AND TextCode = 'travel_time_mandatory');
			GOTO ProcEnd;
		END
		IF ISNULL(@ticket_km, '') = '' AND EXISTS (SELECT * FROM OSCL WHERE callID = @ticket_Id AND U_FatherID IS NULL)
		BEGIN
			SET @errmsg = (SELECT TEXT FROM ACT_PDC_Dictionary WHERE LanguageCode = @language AND TextCode = 'km_mandatory');
			GOTO ProcEnd;
		END
		IF ISNULL(@ticket_bpeMail, '') = '' AND EXISTS (SELECT * FROM OSCL WHERE callID = @ticket_Id AND U_FatherID IS NULL) AND @ticket_notPresentChar = 'N'
		BEGIN
			SET @errmsg = (SELECT TEXT FROM ACT_PDC_Dictionary WHERE LanguageCode = @language AND TextCode = 'email_mandatory');
			GOTO ProcEnd;
		END
		IF LEN(ISNULL(@ticket_description, '')) < 10
		BEGIN
			SET @errmsg = (SELECT TEXT FROM ACT_PDC_Dictionary WHERE LanguageCode = @language AND TextCode = 'short_error_description_mandatory');
			GOTO ProcEnd;
		END

		BEGIN
			UPDATE T1
			SET T1.U_Distance = @ticket_km,
				T1.U_Counter = @ticket_counter,
				T1.U_Location = @ticket_location,
				T1.descrption = @ticket_description,
				T1.StartDate =CAST(SUBSTRING(CONVERT(NVARCHAR(30), @ticket_startDateTime, 121), 1, 10) AS DATETIME),
				T1.StartTime = DATEPART(HOUR, @ticket_startDateTime) * 100 + DATEPART(MINUTE, @ticket_startDateTime),
				T1.EndDate = CAST(SUBSTRING(CONVERT(NVARCHAR(30), @ticket_endDateTime, 121), 1, 10) AS DATETIME),
				T1.EndTime = DATEPART(HOUR, @ticket_endDateTime) * 100 + DATEPART(MINUTE, @ticket_endDateTime),
				T1.Duration = @ticket_duration,
				T1.BPE_Mail = @ticket_bpeMail,
				T1.resolution = @ticket_comingJobs,
				T1.U_ByOffer = @ticket_byOfferChar,
				T1.U_TravelTime = @ticket_travelTime,
				T1.U_ContactName = @ticket_recipient,
				T1.U_NotPresent = @ticket_notPresentChar,
				T1.U_Guarantee = @ticket_guaranteetChar,
				T1.NumAtCard = @ticket_BPReferenceNumber
			FROM OSCL T1
			WHERE T1.callID = @ticket_Id;

			SET @successmsg = (SELECT TEXT FROM ACT_PDC_Dictionary WHERE LanguageCode = @language AND TextCode = 'save_successful');
		END
	END
-- #endregion

-- #region Message output
	-- Ha volt hibaüzenet, akkor azt jelenítsük meg
ProcEnd:
	IF @errmsg != ''
	BEGIN
		SELECT 'Message' AS [Section];
		SELECT @errmsg AS [message], 'error' AS [type];
	END
	ELSE IF @successmsg != ''
	BEGIN
		SELECT 'Message' AS [Section];
		SELECT @successmsg AS [message], 'success' AS [type];
	END
-- #endregion

END
GO

-- ==========================================
-- Type: Procedures
-- Name: [dbo].[ACT_PDC_GETTER]
-- Exported on: 10/31/2025 05:27:20
-- ==========================================

CREATE   PROCEDURE [dbo].[ACT_PDC_GETTER]
	@resource VARCHAR(255),
	@params ParamTableType READONLY
AS
BEGIN
	SET NOCOUNT ON;

-- #region Definitions
	-- Hibaüzenet változó
	DECLARE @errmsg NVARCHAR(254) = '';

	DECLARE @sess_userId NVARCHAR(254) = (SELECT [Value] FROM @params WHERE [Name] = '$User.id');
	DECLARE @language NVARCHAR(10) = ISNULL((SELECT [Value] FROM @params WHERE [Name] = '$Language.code'),'en_GB'); -- hu_HU, en_GB, stb.
	DECLARE @technicianWHS NVARCHAR(50) = (SELECT U_ACT_Whs FROM OHEM WHERE empID = @sess_userId);
-- #endregion

-- #region SessionInfo
	IF @resource = 'SessionInfo'
	BEGIN
		DECLARE @si_session_id NVARCHAR(255) = (SELECT [Value] FROM @params WHERE [Name] = '$Session.id');
		DECLARE @si_session_name NVARCHAR(255) = (SELECT [Value] FROM @params WHERE [Name] = '$Session.name');
		SELECT
			[id] AS [ID],
			[name] AS [Name],
			[status] AS [Status],
			[creationDate] AS [CreationDate],
			[modificationDate] AS [ModificationDate],
			[userId] AS [UserID]
		FROM [@ACT_PDC_SESSIONS]
		WHERE [name] = @si_session_name AND [id] = @si_session_id;
	END
-- #endregion

-- #region Routes
	IF @resource = 'Routes'
	BEGIN
		SELECT
			[Code] AS [ID],
			[U_Route] AS [Route],
			[U_Title] AS [Title],
			[U_Resource] AS [Resource],
			IIF([U_RequireLogin] = 'Y', 'true', 'false') AS [RequireLogin],
			[U_Layout] AS [Layout]
		FROM [@ACT_PDC_ROUTES];
	END
-- #endregion

-- #region Layout
	IF @resource = 'Layout'
	BEGIN

		SELECT 'Texts.Header' AS [Section];
		SELECT (SELECT TEXT FROM ACT_PDC_Dictionary WHERE LanguageCode = @language AND TextCode = 'exit') AS [LogOut];

	END
-- #endregion

-- #region Home
	IF @resource = 'Home'
	BEGIN

		--DECLARE @user_isAdmin INT = IIF((SELECT COUNT(*) FROM HEM6 t00 LEFT JOIN OHTY t01 ON t00.roleID = t01.typeID WHERE t00.empID = @sess_userId AND t01.name = 'Admin') > 0, 1, 0);
		--DECLARE @user_isEmployee INT = IIF((SELECT COUNT(*) FROM HEM6 t00 LEFT JOIN OHTY t01 ON t00.roleID = t01.typeID WHERE t00.empID = @sess_userId AND t01.name = 'Dolgozó') > 0, 1, 0);

		--IF @user_isAdmin = 1
		--BEGIN
		--	SELECT 'Menu' AS [Section];
		--	SELECT N'Példa' AS [title], '/pelda' AS [url], 'fa-solid fa-industry' AS [icon], 2 AS [order] UNION
		--		SELECT N'Adminisztráció' AS [title], '/admin' AS [url], 'fa-solid fa-briefcase' AS [icon], 3 AS [order]
		--	ORDER BY [order] ASC;
		--END
		--ELSE
		--BEGIN
			--IF @user_isEmployee = 1
			--BEGIN
				SELECT 'Menu' AS [Section];
				--SELECT N'Jelenléti ív' AS [title], '/attendance' AS [url], 'fa-solid fa-industry' AS [icon], 1 AS [order] UNION	
				SELECT (SELECT TEXT FROM ACT_PDC_Dictionary WHERE LanguageCode = @language AND TextCode = 'menu_dws') AS [title], '/dwsselection' AS [url], 'fa-solid fa-file-text' AS [icon], 1 AS [order] UNION
				SELECT (SELECT TEXT FROM ACT_PDC_Dictionary WHERE LanguageCode = @language AND TextCode = 'menu_invertorydata') AS [title], '/inventorydata' AS [url], 'fa-solid fa-warehouse' AS [icon], 2 AS [order] UNION
				SELECT(SELECT TEXT FROM ACT_PDC_Dictionary WHERE LanguageCode = @language AND TextCode = 'menu_itemprice') AS [title], '/getitemprice' AS [url], 'fa-solid fa-search-dollar' AS [icon], 3 AS [order]
				ORDER BY [order] ASC;
			--END
		--END

	END
-- #endregion

-- #region FileExplorer
	IF @resource = 'FileExplorer'
	BEGIN

		DECLARE @fileExplorer_Name NVARCHAR(254) = (SELECT [Value] FROM @params WHERE [Name] = 'Name');

		IF @fileExplorer_Name = 'doksiKivalasztas'
		BEGIN
			SELECT 'Volumes' AS [Section];
			SELECT 'C:\path to folder\' AS [Path], 'Main Share' AS [Name];
		END

	END
-- #endregion
	
	IF @resource = 'Calendar.Events'
	BEGIN
		-- ISO formátum, pl.: 2024-10-10T10:00:00.000Z
		DECLARE @calendarEvents_DateRange0 NVARCHAR(254) = ISNULL((SELECT [Value] FROM @params WHERE [Name] = 'Query.DateRange.0'), '');
		DECLARE @calendarEvents_DateRange1 NVARCHAR(254) = ISNULL((SELECT [Value] FROM @params WHERE [Name] = 'Query.DateRange.1'), '');

		DECLARE @calendarEvents_AllWork NVARCHAR(254) = CASE WHEN ISNULL((SELECT [Value] FROM @params WHERE [Name] = 'Query.MindenMunka'), '') = 'true' THEN 'true' ELSE 'false' END;
		DECLARE @calendarEvents_textFilter NVARCHAR(254) = ISNULL((SELECT [Value] FROM @params WHERE [Name] = 'Query.TextFilter'), '');

		DECLARE @calendarEvents_DateRange0_local DATETIME = (SELECT CONVERT(DATE, @calendarEvents_DateRange0, 126) AS FormattedDate); /* konvertáljuk át a helyi időzónára */
		DECLARE @calendarEvents_DateRange1_local DATETIME = (SELECT CONVERT(DATE, @calendarEvents_DateRange1, 126) AS FormattedDate); /* konvertáljuk át a helyi időzónára */

		SELECT
				ISNULL(T0.callID, '')  AS [event.id],
				ISNULL(T0.subject, '') AS [event.title],
				dbo.ConvertSAPToISOFormat(T0.StartDate, T0.StartTime) AS [event.start],
				dbo.ConvertSAPToISOFormat(T0.EndDate, T0.EndTime) AS [event.end],
				CASE T0.callType 
					WHEN '1' THEN '#FFAEC9' -- Telepítés
					WHEN '2' THEN '#22B14C' -- Tervezett karbantartás
					WHEN '3' THEN '#FF7F27' -- Eseti karbantartás
					WHEN '4' THEN CASE ISNULL(T0.U_Guarantee, '') WHEN 'N' THEN '#FFF200' WHEN 'Y' THEN '#7F7F7F' END -- Javítás, nem garis / garis
					WHEN '5' THEN '#3F48CC' -- Felmérés
					WHEN '6' THEN '#ED1C24' -- Teszt
					END AS [event.backgroundColor], 
				'#000000' AS [event.borderColor],
				CASE T0.callType 
					WHEN '1' THEN '#000000'
					WHEN '2' THEN '#FFFFFF'
					WHEN '3' THEN '#FFFFFF' 
					WHEN '4' THEN CASE ISNULL(T0.U_Guarantee, '') WHEN 'N' THEN '#000000' WHEN 'Y' THEN '#FFFFFF' END
					WHEN '5' THEN '#FFFFFF' 
					WHEN '6' THEN '#FFFFFF'
					END AS [event.textColor],
				'true' AS [event.clickable],
				T0.callID AS [ID],
				ISNULL(T0.subject, '') AS [Subject]
			FROM OSCL T0
			WHERE (@calendarEvents_AllWork = 'false' AND (T0.technician = @sess_userId OR T0.U_TechnicianCode2  = @sess_userId OR T0.U_TechnicianCode3  = @sess_userId)
				OR @calendarEvents_AllWork = 'true')
				AND (@calendarEvents_DateRange1 = '' OR T0.StartDate < @calendarEvents_DateRange1_local)
				AND (@calendarEvents_DateRange0 = '' OR T0.EndDate > @calendarEvents_DateRange0_local)
				AND (ISNULL(T0.subject, '') like CONCAT('%', @calendarEvents_textFilter, '%')
					OR T0.manufSN like CONCAT('%', @calendarEvents_textFilter, '%')
					OR T0.custmrName like CONCAT('%', @calendarEvents_textFilter, '%')
					OR T0.U_EndUserName like CONCAT('%', @calendarEvents_textFilter, '%')
					OR CONCAT(T0.U_ZipCode, ' ' ,T0.City, ', ', T0.Street) like CONCAT('%', @calendarEvents_textFilter, '%'))
				AND T0.status <> 2

		UNION ALL

		SELECT T1.empID, 
		CONCAT('Szabadság: ', T1.lastName, ' ', T1.firstName),
		dbo.ConvertSAPToISOFormat(T0.fromDate, 0), 
		dbo.ConvertSAPToISOFormat(T0.toDate, 0),
		'#99D9EA',
		'#000000',
		'#000000',
		'false',
		T1.empID,
		CONCAT('Szabadság: ', T1.lastName, ' ', T1.firstName)
		FROM HEM1 T0
		INNER JOIN OHEM T1 ON T0.empID = T1.empID
		WHERE  ((@calendarEvents_AllWork = 'false' AND T0.empID = @sess_userId)
				OR @calendarEvents_AllWork = 'true')
				AND (@calendarEvents_DateRange1 = '' OR T0.fromDate < @calendarEvents_DateRange1_local)
				AND (@calendarEvents_DateRange0 = '' OR T0.toDate > @calendarEvents_DateRange0_local)
				AND CONCAT('Szabadság: ', T1.lastName, ' ', T1.firstName) like CONCAT('%', @calendarEvents_textFilter, '%')

	END

	--beszerelt
	IF @resource = 'InstalledItems'
	BEGIN
		
		DECLARE @installedItems_Limit INT = ISNULL((SELECT [Value] FROM @params WHERE [Name] = 'Limit'), 20);
		DECLARE @installedItems_Offset INT = ISNULL((SELECT [Value] FROM @params WHERE [Name] = 'Offset'), 0);
		DECLARE @installedItems_ticketId INT = (SELECT [Value] FROM @params WHERE [Name] = 'Query.Id');
		DECLARE @installedItems_ByOQUT NVARCHAR(254) = CASE WHEN ISNULL((SELECT [Value] FROM @params WHERE [Name] = 'Query.AjanlatSzerint'), '') = 'true' THEN 'true' ELSE 'false' END;


		--ha ajánlat szerint kell betölteni, akkor megnézzük, hogy szerepelnek-e már a táblában az ajánlat szerinti sorok. Ha nem, akkor hozzáadjuk
		IF @installedItems_ByOQUT = 'true' AND NOT EXISTS (SELECT * FROM [@ACT_DWS_ITEMS] WHERE U_CallId = @installedItems_ticketId AND U_Installed = 'Y'  AND U_FromOffer = 'Y')
		BEGIN

			DECLARE @installedItems_BaseTicketId INT = (SELECT ISNULL(U_FatherID, callID) FROM OSCL WHERE callID = @installedItems_ticketId)

			-- Ha van az adott híváshoz ajánlat akkor onnan vesszük az adatokat
			IF (SELECT COUNT(T1.LineNum) FROM OQUT T0 INNER JOIN QUT1 T1 ON T0.DocEntry = T1.DocEntry INNER JOIN OITM T2 ON T1.ItemCode = T2.ItemCode WHERE T0.CANCELED = 'N' AND T0.U_ServiceCall = @installedItems_ticketId AND T1.LineStatus = 'O' AND T2.InvntItem = 'Y') > 0
			BEGIN

				INSERT INTO [@ACT_DWS_ITEMS] (U_WhsCode, U_ItemCode, U_SerialNumber, U_Quantity, U_Description, U_Installed, U_FromOffer, U_CallId, U_OpButton, U_Docentry, U_LineNum)
				--ajánlatról a sorok
				SELECT @technicianWHS, t2.ItemCode, '', t2.Quantity, '', 'Y', 'Y', @installedItems_ticketId, 0, t2.DocEntry, t2.LineNum
				FROM OQUT t1 INNER JOIN QUT1 t2 ON (t1.DocEntry = t2.DocEntry)
				INNER JOIN OITM T3 ON T2.ItemCode = T3.ItemCode
				WHERE t1.U_ServiceCall = @installedItems_ticketId AND t1.CANCELED = 'N' AND t2.LineStatus = 'O' AND T3.InvntItem = 'Y'
			
			END

			-- Ha nincs az adott híváshoz ajánlat akkor vesszük a feletteshez tartozóból
			IF (SELECT COUNT(T1.LineNum) FROM OQUT T0 INNER JOIN QUT1 T1 ON T0.DocEntry = T1.DocEntry INNER JOIN OITM T2 ON T1.ItemCode = T2.ItemCode WHERE T0.CANCELED = 'N' AND T0.U_ServiceCall = @installedItems_ticketId AND T1.LineStatus = 'O' AND T2.InvntItem = 'Y') = 0
			BEGIN

				INSERT INTO [@ACT_DWS_ITEMS] (U_WhsCode, U_ItemCode, U_SerialNumber, U_Quantity, U_Description, U_Installed, U_FromOffer, U_CallId, U_OpButton, U_Docentry, U_LineNum)
				--ajánlatról a sorok
				SELECT @technicianWHS, t2.ItemCode, '', t2.Quantity, '', 'Y', 'Y', @installedItems_ticketId, 0, t2.DocEntry, t2.LineNum
				FROM OQUT t1 INNER JOIN QUT1 t2 ON (t1.DocEntry = t2.DocEntry)
				INNER JOIN OITM T3 ON T2.ItemCode = T3.ItemCode
				WHERE t1.U_ServiceCall = @installedItems_BaseTicketId AND t1.CANCELED = 'N' AND t2.LineStatus = 'O' AND T3.InvntItem = 'Y'
			
			END
			
		END

		--megnézzük, hogy szerepelnek-e már a táblában a szerződés szerinti sorok. Ha nem, akkor hozzáadjuk
		IF NOT EXISTS (SELECT * FROM [@ACT_DWS_ITEMS] WHERE U_CallId = @installedItems_ticketId AND U_Installed = 'Y'  AND ISNULL(U_FromContract, 'N') = 'Y')
		BEGIN
			INSERT INTO [@ACT_DWS_ITEMS] (U_WhsCode, U_ItemCode, U_SerialNumber, U_Quantity, U_Description, U_Installed, U_FromOffer, U_CallId, U_OpButton, U_FromContract)
			SELECT @technicianWHS, T2.U_ItemCode, '', T2.U_Quantity, '', 'Y', 'N', @installedItems_ticketId, 0, 'Y' FROM OSCL T0
				INNER JOIN [@ACT_MAINT_MCH] T1 ON T0.manufSN = T1.U_ManufSN
				INNER JOIN [@ACT_MAINT_ROW] T2 ON T1.DocEntry = T2.DocEntry
				INNER JOIN [@ACT_MAINT_HEAD] T3 ON T2.DocEntry = T3.DocEntry
				INNER JOIN OITM T4 ON T2.U_ItemCode = T4.ItemCode
			WHERE T0.callType = 2
				AND T0.callID = @installedItems_ticketId
				AND CONVERT(date, T0.StartDate) BETWEEN ISNULL(T3.U_FromDate, '1900.01.01') AND ISNULL(T3.U_ToDate, '2099.12.31')
				AND T4.InvntItem = 'Y'
			ORDER BY T2.LineId
		END

		--ha nincs benne üres sor, hozzáadunk egyet
		IF NOT EXISTS (SELECT * FROM [@ACT_DWS_ITEMS] WHERE U_CallId = @installedItems_ticketId AND U_Installed = 'Y' 
			AND ISNULL(U_ItemCode, '') = '' AND ISNULL(U_SerialNumber, '') = '' AND U_OpButton = 0 AND U_Quantity = 0 AND ISNULL(U_Description, '') = '')
		BEGIN
			INSERT INTO [@ACT_DWS_ITEMS] (U_WhsCode, U_ItemCode, U_SerialNumber, U_Quantity, U_Description, U_Installed, U_FromOffer, U_CallId, U_OpButton)
			SELECT @technicianWHS, '', '', 0, '', 'Y', 'N', @installedItems_ticketId, 0
		END

		SELECT 'Table' AS [Section];
		SELECT t1.Code AS [Code],
			FORMAT(t1.U_Quantity, '0.00', 'hu-HU') AS [Quantity],
			t1.U_SerialNumber AS [SerialNumber.id],
			t1.U_SerialNumber AS [SerialNumber.text],
			t3.ItemCode AS [ItemCode.id],
			CONCAT(t3.ItemCode, ' - ', t3.ItemName) AS [ItemCode.text],
			t1.U_Description AS [Description],
			t1.U_OpButton AS [OpButton],
			t1.U_FromOffer AS [FromOffer]
		FROM [@ACT_DWS_ITEMS] t1 
			LEFT JOIN OITM t3 ON (t1.U_ItemCode = t3.ItemCode)
		WHERE t1.U_CallId = @installedItems_ticketId AND t1.U_Installed = 'Y' AND (t1.U_FromOffer = 'N' OR (t1.U_FromOffer = 'Y' AND @installedItems_ByOQUT = 'true'))
			AND t1.U_OpButton = 0
		ORDER BY t1.Code
		OFFSET @installedItems_Offset ROWS FETCH NEXT @installedItems_Limit ROWS ONLY;

	END

	--kiszerelt
	IF @resource = 'DismantledItems'
	BEGIN
		
		DECLARE @dismantledItems_Limit INT = ISNULL((SELECT [Value] FROM @params WHERE [Name] = 'Limit'), 20);
		DECLARE @dismantledItems_Offset INT = ISNULL((SELECT [Value] FROM @params WHERE [Name] = 'Offset'), 0);
		DECLARE @dismantledItems_ticketId INT = (SELECT [Value] FROM @params WHERE [Name] = 'Query.Id');

		--ha nincs benne üres sor, hozzáadunk egyet
		IF NOT EXISTS (SELECT * FROM [@ACT_DWS_ITEMS] WHERE U_CallId = @dismantledItems_ticketId AND U_Installed = 'N' 
			AND ISNULL(U_ItemCode, '') = '' AND ISNULL(U_SerialNumber, '') = '' AND U_OpButton = 0 AND U_Quantity = 0 AND ISNULL(U_Description, '') = '')
		BEGIN
			INSERT INTO [@ACT_DWS_ITEMS] (U_WhsCode, U_ItemCode, U_SerialNumber, U_Quantity, U_Description, U_Installed, U_FromOffer, U_CallId, U_OpButton)
			SELECT @technicianWHS, '', '', 0, '', 'N', 'N', @dismantledItems_ticketId, 0
		END


		SELECT 'Table' AS [Section];
		SELECT t1.Code AS [Code],
			FORMAT(t1.U_Quantity, '0.00', 'hu-HU') AS [Quantity],
			t1.U_SerialNumber AS [SerialNumber],
			t3.ManSerNum AS [ManSerNum],
			t3.ItemCode AS [ItemCode.id],
			CONCAT(t3.ItemCode, ' - ', t3.ItemName) AS [ItemCode.text],
			--t2.WhsCode AS [Warehouse.id],
			--CONCAT(t2.WhsCode, ' - ', t2.WhsName) AS [Warehouse.text],
			t1.U_Description AS [Description],
			t1.U_OpButton AS [OpButton]
		FROM [@ACT_DWS_ITEMS] t1 --LEFT JOIN OWHS t2 ON (t1.U_WhsCode = t2.WhsCode)
			LEFT JOIN OITM t3 ON (t1.U_ItemCode = t3.ItemCode)
		WHERE t1.U_CallId = @dismantledItems_ticketId AND t1.U_Installed = 'N' AND t1.U_OpButton = 0
		ORDER BY t1.Code
		OFFSET @dismantledItems_Offset ROWS FETCH NEXT @dismantledItems_Limit ROWS ONLY;

	END

	--teljes cikktörzs
	IF @resource = 'DismantledItemCodes'
	BEGIN
		DECLARE @dismantledItemCodes_Limit INT = ISNULL((SELECT [Value] FROM @params WHERE [Name] = 'Limit'), 20);
		DECLARE @dismantledItemCodes_Offset INT = ISNULL((SELECT [Value] FROM @params WHERE [Name] = 'Offset'), 0);
		DECLARE @dismantledItemCodes_term NVARCHAR(254) = ISNULL((SELECT [Value] FROM @params WHERE [Name] = 'Term'), '');
		SELECT
			t0.[ItemCode] AS [id],
			t0.[ItemCode] + ' - ' + t0.[ItemName] AS [text]
		FROM OITM t0
		WHERE (@dismantledItemCodes_term = '' OR t0.[ItemCode] + ' - '+ t0.[ItemName] LIKE '%' + @dismantledItemCodes_term + '%')
		ORDER BY 1 OFFSET @dismantledItemCodes_Offset ROWS FETCH NEXT @dismantledItemCodes_Limit ROWS ONLY;
	END

	--teljes cikktörzs árral
	IF @resource = 'AllItemCodes'
	BEGIN
		DECLARE @allItemCodes_Limit INT = ISNULL((SELECT [Value] FROM @params WHERE [Name] = 'Limit'), 20);
		DECLARE @allItemCodes_Offset INT = ISNULL((SELECT [Value] FROM @params WHERE [Name] = 'Offset'), 0);
		DECLARE @allItemCodes_term NVARCHAR(254) = ISNULL((SELECT [Value] FROM @params WHERE [Name] = 'Term'), '');
		SELECT
			t0.[ItemCode] AS [id],
			t0.[ItemCode] + ' - ' + t0.[ItemName] AS [text]--,
			--t0.AvgPrice AS [Price]
		FROM OITM t0
		WHERE (@allItemCodes_term = '' OR t0.[ItemCode] + ' - '+ t0.[ItemName] LIKE '%' + @allItemCodes_term + '%')
		ORDER BY 1 OFFSET @allItemCodes_Offset ROWS FETCH NEXT @allItemCodes_Limit ROWS ONLY;
	END

	IF @resource = 'Pricelists'
	BEGIN
		DECLARE @pricelists_Limit INT = ISNULL((SELECT [Value] FROM @params WHERE [Name] = 'Limit'), 20);
		DECLARE @pricelists_Offset INT = ISNULL((SELECT [Value] FROM @params WHERE [Name] = 'Offset'), 0);
		DECLARE @pricelists_term NVARCHAR(254) = ISNULL((SELECT [Value] FROM @params WHERE [Name] = 'Term'), '');
		SELECT
			t0.[ListNum] AS [id],
			CONCAT(t0.[ListNum], ' - ', t0.[ListName]) AS [text]
		FROM OPLN t0
		WHERE t0.GroupCode IN (1, 6)
			AND (@pricelists_term = '' OR t0.[ListNum] + ' - '+ t0.[ListName] LIKE '%' + @pricelists_term + '%')
		ORDER BY 1 OFFSET @pricelists_Offset ROWS FETCH NEXT @pricelists_Limit ROWS ONLY;
	END

	IF @resource = 'CardCodes'
	BEGIN
		DECLARE @cardcodes_Limit INT = ISNULL((SELECT [Value] FROM @params WHERE [Name] = 'Limit'), 20);
		DECLARE @cardcodes_Offset INT = ISNULL((SELECT [Value] FROM @params WHERE [Name] = 'Offset'), 0);
		DECLARE @cardcodes_term NVARCHAR(254) = ISNULL((SELECT [Value] FROM @params WHERE [Name] = 'Term'), '');
		SELECT
			t0.CardCode AS [id],
			CONCAT(t0.CardCode, ' - ', t0.CardName) AS [text]
		FROM OCRD t0 
		WHERE t0.CardType = 'C'
			AND (@cardcodes_term = '' OR t0.CardCode + ' - '+ t0.CardName LIKE '%' + @cardcodes_term + '%')
		ORDER BY t0.CardName OFFSET @cardcodes_Offset ROWS FETCH NEXT @cardcodes_Limit ROWS ONLY;
	END


	IF @resource = 'InstalledSerialNumbers'
	BEGIN
		DECLARE @serialNumbers_Limit INT = ISNULL((SELECT [Value] FROM @params WHERE [Name] = 'Limit'), 20);
		DECLARE @serialNumbers_Offset INT = ISNULL((SELECT [Value] FROM @params WHERE [Name] = 'Offset'), 0);
		DECLARE @serialNumbers_term NVARCHAR(254) = ISNULL((SELECT [Value] FROM @params WHERE [Name] = 'Term'), '');

		DECLARE @serialNumbers_ItemCode NVARCHAR(254) = ISNULL((SELECT [Value] FROM @params WHERE [Name] = 'Query.ItemCode.id'), '');

		SELECT 
				T1.[MnfSerial] AS [id],
				T1.[MnfSerial] AS [text]
		FROM OSRQ T0
		INNER JOIN OSRN T1 ON T0.ItemCode = T1.ItemCode AND T0.SysNumber = T1.SysNumber
		INNER JOIN OITM T2 ON T1.ItemCode = T2.ItemCode
		WHERE (@serialNumbers_term = '' OR t1.[MnfSerial] LIKE '%' + @serialNumbers_term + '%')
			AND T0.WhsCode = @technicianWHS AND T2.OnHand > 0 AND T0.Quantity > 0
			AND T2.ItemCode = CASE WHEN @serialNumbers_ItemCode <> '' THEN @serialNumbers_ItemCode ELSE T2.ItemCode END
		ORDER BY 1 OFFSET @serialNumbers_Offset ROWS FETCH NEXT @serialNumbers_Limit ROWS ONLY;

	END

	/*IF @resource = 'DismantledSerialNumbers'
	BEGIN
		DECLARE @dismantledSerialNumbers_Limit INT = ISNULL((SELECT [Value] FROM @params WHERE [Name] = 'Limit'), 20);
		DECLARE @dismantledSerialNumbers_Offset INT = ISNULL((SELECT [Value] FROM @params WHERE [Name] = 'Offset'), 0);
		DECLARE @dismantledSerialNumbers_term NVARCHAR(254) = ISNULL((SELECT [Value] FROM @params WHERE [Name] = 'Term'), '');
		
		DECLARE @dismantledSerialNumbers_ItemCode NVARCHAR(254) = ISNULL((SELECT [Value] FROM @params WHERE [Name] = 'Query.ItemCode.id'), '');
		SELECT 
				T1.[MnfSerial] AS [id],
				T1.[MnfSerial] AS [text]
		FROM OSRQ T0
		INNER JOIN OSRN T1 ON T0.ItemCode = T1.ItemCode AND T0.SysNumber = T1.SysNumber
		INNER JOIN OITM T2 ON T1.ItemCode = T2.ItemCode
		WHERE (@dismantledSerialNumbers_term = '' OR t1.[MnfSerial] LIKE '%' + @dismantledSerialNumbers_term + '%')
			AND T2.ItemCode = CASE WHEN @dismantledSerialNumbers_ItemCode <> '' THEN @dismantledSerialNumbers_ItemCode ELSE T2.ItemCode END
		--UNION ALL SELECT @dismantledSerialNumbers_term, @dismantledSerialNumbers_term
		ORDER BY 1 OFFSET @dismantledSerialNumbers_Offset ROWS FETCH NEXT @dismantledSerialNumbers_Limit ROWS ONLY
		

	END*/

	IF @resource = 'InstalledItemCodes'
	BEGIN
		DECLARE @installedItemCodes_Limit INT = ISNULL((SELECT [Value] FROM @params WHERE [Name] = 'Limit'), 20);
		DECLARE @installedItemCodes_Offset INT = ISNULL((SELECT [Value] FROM @params WHERE [Name] = 'Offset'), 0);
		DECLARE @installedItemCodes_term NVARCHAR(254) = ISNULL((SELECT [Value] FROM @params WHERE [Name] = 'Term'), '');
		DECLARE @installedItemCodes_callId NVARCHAR(254) = ISNULL((SELECT [Value] FROM @params WHERE [Name] = 'Query.CallId'), '');

		SELECT
			t2.[ItemCode] AS [id],
			t2.[ItemCode] + ' - ' + t2.[ItemName] AS [text]
		FROM OSRQ T0
		RIGHT JOIN OSRN T1 ON T0.ItemCode = T1.ItemCode AND T0.SysNumber = T1.SysNumber
		RIGHT JOIN OITM T2 ON T1.ItemCode = T2.ItemCode
		RIGHT JOIN OITW T3 ON T2.ItemCode = T3.ItemCode
		LEFT JOIN (SELECT T6.ItemCode, SUM(T6.Quantity) AS Qty FROM OSCL T4 INNER JOIN ODRF T5 ON T4.U_ItemIn = T5.DocEntry INNER JOIN DRF1 T6 ON T5.DocEntry = T6.DocEntry
		WHERE ISNULL(T4.U_ItemIn, '') <> '' AND	T5.DocStatus = 'O' AND T6.WhsCode = @technicianWHS
		GROUP BY T6.ItemCode) T00 ON (T00.ItemCode = T2.ItemCode)
		LEFT JOIN (SELECT T6.ItemCode, SUM(T6.Quantity) AS Qty FROM OSCL T4 INNER JOIN ODRF T5 ON T4.U_ItemIn = T5.DocEntry INNER JOIN DRF1 T6 ON T5.DocEntry = T6.DocEntry
		WHERE ISNULL(T4.U_ItemOut, '') <> '' AND T5.DocStatus = 'O' AND T6.WhsCode = @technicianWHS
		GROUP BY T6.ItemCode) T01 ON (T01.ItemCode = T2.ItemCode)
		WHERE (@installedItemCodes_term = '' OR t2.[ItemCode] + ' - '+ t2.[ItemName] LIKE '%' + @installedItemCodes_term + '%')
			AND T3.WhsCode = @technicianWHS AND T3.OnHand - ISNULL(T00.Qty,0) + ISNULL(T01.Qty,0) > 0
		GROUP BY t2.[ItemCode], T2.[ItemName]
		ORDER BY 1 OFFSET @installedItemCodes_Offset ROWS FETCH NEXT @installedItemCodes_Limit ROWS ONLY;
	END

	/*IF @resource = 'WarehouseIds'
	BEGIN
		DECLARE @warehouses_Limit INT = ISNULL((SELECT [Value] FROM @params WHERE [Name] = 'Limit'), 20);
		DECLARE @warehouses_Offset INT = ISNULL((SELECT [Value] FROM @params WHERE [Name] = 'Offset'), 0);
		DECLARE @warehouses_term NVARCHAR(254) = ISNULL((SELECT [Value] FROM @params WHERE [Name] = 'Term'), '');
		SELECT
			t0.[WhsCode] AS [id],
			t0.[WhsCode] + ' - ' + t0.[WhsName] AS [text]
		FROM OWHS t0
		WHERE (@warehouses_term = '' OR t0.[WhsCode] + ' - ' + t0.[WhsName] LIKE '%' + @warehouses_term + '%')
		ORDER BY 1 OFFSET @warehouses_Offset ROWS FETCH NEXT @warehouses_Limit ROWS ONLY;
	END
	*/

	IF @resource = 'InventoryItemCodes'
	BEGIN
		DECLARE @inventoryItemcCodes_Limit INT = ISNULL((SELECT [Value] FROM @params WHERE [Name] = 'Limit'), 20);
		DECLARE @inventoryItemCodes_Offset INT = ISNULL((SELECT [Value] FROM @params WHERE [Name] = 'Offset'), 0);
		DECLARE @inventoryItemCodes_term NVARCHAR(254) = ISNULL((SELECT [Value] FROM @params WHERE [Name] = 'Term'), '');
		SELECT
			t0.[ItemCode] AS [id],
			t0.[ItemCode] + ' - ' + t0.[ItemName] AS [text]
		FROM OITM t0
		WHERE (@inventoryItemCodes_term = '' OR t0.[ItemCode] + ' - '+ t0.[ItemName] LIKE '%' + @inventoryItemCodes_term + '%')  AND T0.InvntItem = 'Y'
		ORDER BY 1 OFFSET @inventoryItemCodes_Offset ROWS FETCH NEXT @inventoryItemcCodes_Limit ROWS ONLY;
	END

	IF @resource = 'InventoryData'
	BEGIN
		
		DECLARE @inventoryData_Limit INT = ISNULL((SELECT [Value] FROM @params WHERE [Name] = 'Limit'), 20);
		DECLARE @inventoryDat_Offset INT = ISNULL((SELECT [Value] FROM @params WHERE [Name] = 'Offset'), 0);
		DECLARE @inventoryData_ItemCode NVARCHAR(254) = ISNULL((SELECT [Value] FROM @params WHERE [Name] = 'Query.ItemCodeFilter'), '');

		SELECT 'Table' AS [Section];
		SELECT T1.ItemCode AS [ItemCode], T1.ItemName AS [ItemName], T2.WhsName AS [Whs], FORMAT(T0.OnHand - ISNULL(T00.Qty,0) + ISNULL(T01.Qty,0), '0.00', 'hu-HU') AS [Quantity] FROM OITW T0
		INNER JOIN OITM T1 ON T0.ItemCode = T1.ItemCode
		INNER JOIN OWHS T2 ON T0.WhsCode = T2.WhsCode
		LEFT JOIN (SELECT T6.ItemCode, T6.WhsCode, SUM(T6.Quantity) AS Qty FROM OSCL T4 INNER JOIN ODRF T5 ON T4.U_ItemIn = T5.DocEntry INNER JOIN DRF1 T6 ON T5.DocEntry = T6.DocEntry
		WHERE ISNULL(T4.U_ItemIn, '') <> '' AND	T5.DocStatus = 'O'
		GROUP BY T6.ItemCode, T6.WhsCode) T00 ON (T00.ItemCode = T1.ItemCode AND T00.WhsCode = T2.WhsCode)
		LEFT JOIN (SELECT T6.ItemCode, T6.WhsCode, SUM(T6.Quantity) AS Qty FROM OSCL T4 INNER JOIN ODRF T5 ON T4.U_ItemIn = T5.DocEntry INNER JOIN DRF1 T6 ON T5.DocEntry = T6.DocEntry
		WHERE ISNULL(T4.U_ItemOut, '') <> '' AND T5.DocStatus = 'O'
		GROUP BY T6.ItemCode, T6.WhsCode) T01 ON (T01.ItemCode = T1.ItemCode AND T01.WhsCode = T2.WhsCode)
		WHERE (T0.WhsCode IN (SELECT U_ACT_Whs FROM OHEM WHERE ISNULL(U_ACT_Whs, '') <> '' AND U_ACT_Whs NOT IN ('RA', 'PZ')) OR T0.WhsCode IN ('SAJAT', 'VEVO'))
		AND T0.OnHand - ISNULL(T00.Qty,0) + ISNULL(T01.Qty,0) > 0  AND T1.InvntItem = 'Y' AND  T1.ItemCode =CASE WHEN @inventoryData_ItemCode <> '' THEN @inventoryData_ItemCode ELSE T1.ItemCode END
		ORDER BY T0.ItemCode, T2.WhsName
		OFFSET @inventoryDat_Offset ROWS FETCH NEXT @inventoryData_Limit ROWS ONLY;

		SELECT 'Pagination' AS [Section];
		SELECT
			COUNT(*) AS [totalRowCount]
		FROM OITW T0
		INNER JOIN OITM T1 ON T0.ItemCode = T1.ItemCode
		INNER JOIN OWHS T2 ON T0.WhsCode = T2.WhsCode
		LEFT JOIN (SELECT T6.ItemCode, T6.WhsCode, SUM(T6.Quantity) AS Qty FROM OSCL T4 INNER JOIN ODRF T5 ON T4.U_ItemIn = T5.DocEntry INNER JOIN DRF1 T6 ON T5.DocEntry = T6.DocEntry
		WHERE ISNULL(T4.U_ItemIn, '') <> '' AND	T5.DocStatus = 'O'
		GROUP BY T6.ItemCode, T6.WhsCode) T00 ON (T00.ItemCode = T1.ItemCode AND T00.WhsCode = T2.WhsCode)
		LEFT JOIN (SELECT T6.ItemCode, T6.WhsCode, SUM(T6.Quantity) AS Qty FROM OSCL T4 INNER JOIN ODRF T5 ON T4.U_ItemIn = T5.DocEntry INNER JOIN DRF1 T6 ON T5.DocEntry = T6.DocEntry
		WHERE ISNULL(T4.U_ItemOut, '') <> '' AND T5.DocStatus = 'O'
		GROUP BY T6.ItemCode, T6.WhsCode) T01 ON (T01.ItemCode = T1.ItemCode AND T01.WhsCode = T2.WhsCode)
		WHERE (T0.WhsCode IN (SELECT U_ACT_Whs FROM OHEM WHERE ISNULL(U_ACT_Whs, '') <> '' AND U_ACT_Whs NOT IN ('RA', 'PZ')) OR T0.WhsCode IN ('SAJAT', 'VEVO'))
		AND T0.OnHand - ISNULL(T00.Qty,0) + ISNULL(T01.Qty,0) > 0 AND T1.InvntItem = 'Y'  AND  T1.ItemCode = CASE WHEN @inventoryData_ItemCode <> '' THEN @inventoryData_ItemCode ELSE T1.ItemCode END
	END

-- #region Message output
	-- Ha volt hibaüzenet, akkor azt jelenítsük meg
	IF @errmsg != ''
	BEGIN
		SELECT 'Message' AS [Section];
		SELECT @errmsg AS [message], 'error' AS [type];
	END
-- #endregion

END
GO

-- ==========================================
-- Type: Procedures
-- Name: [dbo].[ACT_PDC_ROUTE]
-- Exported on: 10/31/2025 05:27:20
-- ==========================================

CREATE   PROCEDURE [dbo].[ACT_PDC_ROUTE]
	@resource VARCHAR(255),
	@params ParamTableType READONLY
AS
BEGIN
	SET NOCOUNT ON;

-- #region Definitions
	DECLARE @sess_userId NVARCHAR(254) = (SELECT [Value] FROM @params WHERE [Name] = '$User.id');
	DECLARE @language NVARCHAR(10) = (SELECT [Value] FROM @params WHERE [Name] = '$Language.code'); -- hu_HU, en_GB, stb.
	DECLARE @technicianName NVARCHAR(254) = (SELECT CONCAT(lastName, ' ', firstName) FROM OHEM WHERE empID = @sess_userId);
-- #endregion

-- NOTE: A példafájlokban történt módosítások a frissítésekkel elvesznek, ezért fontos átmásolni őket a templates mappába módosítás előtt!!!
-- #region Inject examples/home.before.twig
	IF LEFT(@resource, 7) != 'public_'
	BEGIN
		SELECT 'BeforeContent' AS [Section];
		SELECT 'home.before.twig' AS [TemplateFile];
	END
-- #endregion

	IF @resource = 'DwsSelection'
	BEGIN

		SELECT 'dws_selection.twig' AS [TemplateFile];
		
		SELECT 'Data' AS [Section];
		SELECT 
			(SELECT TEXT FROM ACT_PDC_Dictionary WHERE LanguageCode = @language AND TextCode = 'all_work') AS [form.data.allworklabel],
			(SELECT TEXT FROM ACT_PDC_Dictionary WHERE LanguageCode = @language AND TextCode = 'text_filter') AS [form.data.textFilterLabel]

		SELECT 'Breadcrumbs' AS [Section];
			SELECT '/' AS [url], (SELECT TEXT FROM ACT_PDC_Dictionary WHERE LanguageCode = @language AND TextCode = 'home') AS [title], 1 AS [order] UNION
			SELECT '/dwsselection' AS [url], (SELECT TEXT FROM ACT_PDC_Dictionary WHERE LanguageCode = @language AND TextCode = 'works') AS [title], 2 AS [order]
			ORDER BY [order] ASC;

	END

	IF @resource = 'DwsTicket'
	BEGIN

		DECLARE @ticketId INT = (SELECT [Value] FROM @params WHERE [Name] = 'Id');
		SELECT 'dws_ticket.twig' AS [TemplateFile];

		DECLARE @baseticketId INT = (SELECT ISNULL(U_FatherID, callID) FROM OSCL WHERE callID = @ticketId)


		--HA hiba van: SQLSTATE[21000]: [Microsoft][ODBC Driver 17 for SQL Server][SQL Server]Subquery returned more than 1 value. This is not permitted when the subquery follows =, !=, <, <= , >, >= or when the subquery is used as an expression.
		--Akkor az azért van mert több DocNum tartozik a szervízhíváshoz
		DECLARE @quotno_ticket int = (SELECT DocNum FROM OQUT WHERE U_ServiceCall = @ticketId)
		DECLARE @quotno_base int = (SELECT DocNum FROM OQUT WHERE U_ServiceCall = @baseticketId AND CANCELED = 'N')
		
		IF ISNULL(@quotno_ticket, 0) = 0 BEGIN SET @quotno_ticket = @quotno_base END
		
		SELECT 'Data' AS [Section];
		SELECT 
			(SELECT TEXT FROM ACT_PDC_Dictionary WHERE LanguageCode = @language AND TextCode = 'really_confirm')  AS [form.data.ReallyConfirmbel],
			(SELECT TEXT FROM ACT_PDC_Dictionary WHERE LanguageCode = @language AND TextCode = 'confirm')  AS [form.data.Confirmlabel],
			(SELECT TEXT FROM ACT_PDC_Dictionary WHERE LanguageCode = @language AND TextCode = 'yes')  AS [form.data.Yeslabel],
			(SELECT TEXT FROM ACT_PDC_Dictionary WHERE LanguageCode = @language AND TextCode = 'no')  AS [form.data.Nolabel],
			CASE WHEN T0.U_NotPresent = 'Y' THEN 'true' ELSE 'false' END AS [form.data.NotAttended],
			(SELECT TEXT FROM ACT_PDC_Dictionary WHERE LanguageCode = @language AND TextCode = 'not_present')  AS [form.data.NotAttendedlabel],

			(SELECT TEXT FROM ACT_PDC_Dictionary WHERE LanguageCode = @language AND TextCode = 'save')  AS [form.data.Savelabel],
			(SELECT TEXT FROM ACT_PDC_Dictionary WHERE LanguageCode = @language AND TextCode = 'generate_worksheet')  AS [form.data.DWSGeneratelabel],
			(SELECT TEXT FROM ACT_PDC_Dictionary WHERE LanguageCode = @language AND TextCode = 'preview_worksheet')  AS [form.data.DWSPreviewlabel],
			(SELECT TEXT FROM ACT_PDC_Dictionary WHERE LanguageCode = @language AND TextCode = 'ticket')  AS [form.data.Ticketlabel],
			(SELECT TEXT FROM ACT_PDC_Dictionary WHERE LanguageCode = @language AND TextCode = 'material_consumption')  AS [form.data.MaterialConsumptionlabel],
			1 AS [form.data.tab],
			@ticketId AS [form.data.Id],
			CASE WHEN T0.U_Guarantee='Y' THEN 'true' END AS [form.data.Garancialis],
			(SELECT TEXT FROM ACT_PDC_Dictionary WHERE LanguageCode = @language AND TextCode = 'warranty')  AS [form.data.Garancialislabel],
			T0.itemName AS [form.data.KeszulekMegnevezese],
			(SELECT TEXT FROM ACT_PDC_Dictionary WHERE LanguageCode = @language AND TextCode = 'device_name')  AS [form.data.DeviceNamelabel],
			T0.itemCode AS [form.data.KeszulekTipusszam],
			(SELECT TEXT FROM ACT_PDC_Dictionary WHERE LanguageCode = @language AND TextCode = 'type_number')  AS [form.data.TypeNumberlabel],
			T0.manufSN AS [form.data.GyartasiSzam],
			(SELECT TEXT FROM ACT_PDC_Dictionary WHERE LanguageCode = @language AND TextCode = 'production_number')  AS [form.data.ProductionNumberlabel],
			T0.custmrName AS [form.data.MegrendeloNeve],
			(SELECT TEXT FROM ACT_PDC_Dictionary WHERE LanguageCode = @language AND TextCode = 'customer_name')  AS [form.data.CustomerNamelabel],
			CONCAT(T0.U_ZipCode, ' ' ,T0.City, ', ', T0.Street) AS [form.data.MegrendeloCime],
			(SELECT TEXT FROM ACT_PDC_Dictionary WHERE LanguageCode = @language AND TextCode = 'address')  AS [form.data.Addresslabel],
			T0.U_EndUserName AS [form.data.UzemeltetoNeve],
			(SELECT TEXT FROM ACT_PDC_Dictionary WHERE LanguageCode = @language AND TextCode = 'operator_name')  AS [form.data.OperatorNamelabel],
			T1.Descriptio AS [form.data.HivasFajtaja],
			(SELECT TEXT FROM ACT_PDC_Dictionary WHERE LanguageCode = @language AND TextCode = 'call_type')  AS [form.data.CallTypelabel],
			CASE WHEN T0.U_OverWorkTime = 'Y' THEN 'true' ELSE 'false' END AS [form.data.MunkaIdonKivuli],
			(SELECT TEXT FROM ACT_PDC_Dictionary WHERE LanguageCode = @language AND TextCode = 'work_outside_working_hours')  AS [form.data.WorkOutsidelabel],
			dbo.ConvertSAPToISOFormat(T0.StartDate, T0.StartTime) AS [form.data.MunkaMegkezdes],
			(SELECT TEXT FROM ACT_PDC_Dictionary WHERE LanguageCode = @language AND TextCode = 'work_start')  AS [form.data.WorkStartlabel],
			dbo.ConvertSAPToISOFormat(T0.EndDate, T0.EndTime) AS [form.data.MunkaBefejezes],
			(SELECT TEXT FROM ACT_PDC_Dictionary WHERE LanguageCode = @language AND TextCode = 'work_end')  AS [form.data.WorkEndlabel],
			T0.U_TravelTime AS [form.data.UtazasiIdo],
			(SELECT TEXT FROM ACT_PDC_Dictionary WHERE LanguageCode = @language AND TextCode = 'travel_time')  AS [form.data.TravelTimelabel],
			T0.U_Distance AS [form.data.Km],
			(SELECT TEXT FROM ACT_PDC_Dictionary WHERE LanguageCode = @language AND TextCode = 'km')  AS [form.data.Kmlabel],
			T0.U_Counter AS [form.data.Szamlaloallas],
			(SELECT TEXT FROM ACT_PDC_Dictionary WHERE LanguageCode = @language AND TextCode = 'counter')  AS [form.data.Counterlabel],
			T0.descrption AS [form.data.HibaLeiras],
			(SELECT TEXT FROM ACT_PDC_Dictionary WHERE LanguageCode = @language AND TextCode = 'short_error_description')  AS [form.data.ShortErrorDescriptionlabel],
			T0.resolution AS [form.data.EsedekesMunkak],
			(SELECT TEXT FROM ACT_PDC_Dictionary WHERE LanguageCode = @language AND TextCode = 'due_works')  AS [form.data.DueWorkslabel],
			@technicianName AS [form.data.Technikus],
			(SELECT TEXT FROM ACT_PDC_Dictionary WHERE LanguageCode = @language AND TextCode = 'technician')  AS [form.data.Technicianlabel],
			T0.U_ContactName AS [form.data.Atvevo],
			(SELECT TEXT FROM ACT_PDC_Dictionary WHERE LanguageCode = @language AND TextCode = 'recipient')  AS [form.data.Recipientlabel],
			T0.BPE_Mail AS [form.data.AtvevoEmail],
			(SELECT TEXT FROM ACT_PDC_Dictionary WHERE LanguageCode = @language AND TextCode = 'recipient_email')  AS [form.data.RecipientEmaillabel],
			'\' AS [form.data.link],
			CASE WHEN ISNULL(@quotno_ticket, 0) = 0 THEN (SELECT TEXT FROM ACT_PDC_Dictionary WHERE LanguageCode = @language AND TextCode = 'not_assigned_to_offer') ELSE CONVERT(NVARCHAR(30), @quotno_ticket) END AS [form.data.AjanlatSzam],
			(SELECT TEXT FROM ACT_PDC_Dictionary WHERE LanguageCode = @language AND TextCode = 'offer_number')  AS [form.data.OfferNumberlabel],
			CASE WHEN T0.U_ByOffer = 'Y' THEN 'true' ELSE 'false' END AS [form.data.AjanlatSzerint],
			(SELECT TEXT FROM ACT_PDC_Dictionary WHERE LanguageCode = @language AND TextCode = 'by_offer')  AS [form.data.ByOfferlabel],
			(SELECT TEXT FROM ACT_PDC_Dictionary WHERE LanguageCode = @language AND TextCode = 'installed_items')  AS [form.data.InstalledItemslabel],
			(SELECT TEXT FROM ACT_PDC_Dictionary WHERE LanguageCode = @language AND TextCode = 'dismantled_items')  AS [form.data.DismantledItemslabel],
			(SELECT TEXT FROM ACT_PDC_Dictionary WHERE LanguageCode = @language AND TextCode = 'item_code_description')  AS [form.data.ItemCodeDescriptionlabel],
			(SELECT TEXT FROM ACT_PDC_Dictionary WHERE LanguageCode = @language AND TextCode = 'serial_number')  AS [form.data.SerialNumberlabel],
			(SELECT TEXT FROM ACT_PDC_Dictionary WHERE LanguageCode = @language AND TextCode = 'quantity')  AS [form.data.Quantitylabel],
			(SELECT TEXT FROM ACT_PDC_Dictionary WHERE LanguageCode = @language AND TextCode = 'comment')  AS [form.data.Commentlabel],
			(SELECT TEXT FROM ACT_PDC_Dictionary WHERE LanguageCode = @language AND TextCode = 'error_description')  AS [form.data.ErrorDescriptionlabel],
			(SELECT TEXT FROM ACT_PDC_Dictionary WHERE LanguageCode = @language AND TextCode = 'operation')  AS [form.data.Operationlabel],
			(SELECT TEXT FROM ACT_PDC_Dictionary WHERE LanguageCode = @language AND TextCode = 'location')  AS [form.data.Locationlabel],
			T0.U_Location AS [form.data.HelyiAzonosito],
			T0.subject AS [form.data.JegyNeve],
			T0.NumAtCard AS [form.data.BPReferenceNumber],
			(SELECT TEXT FROM ACT_PDC_Dictionary WHERE LanguageCode = @language AND TextCode = 'bp_reference_number') AS [form.data.BPReferenceNumberlabel]
		FROM OSCL T0 LEFT JOIN OSCT t1 ON (t0.callType = t1.callTypeID) 
			LEFT JOIN OHEM t2 ON (t0.technician = t2.Code)
			LEFT JOIN OQUT t3 ON (t3.U_ServiceCall = T0.callID)
		WHERE T0.callID = @ticketId;
		--ami nincs lezárva? vagy ha lezárt akkor minden mező szürke, de jelenjen meg? Befejezett?
		SELECT 'Breadcrumbs' AS [Section];
			SELECT '/' AS [url], (SELECT TEXT FROM ACT_PDC_Dictionary WHERE LanguageCode = @language AND TextCode = 'home') AS [title], 1 AS [order] UNION
			SELECT '/dwsselection' AS [url], (SELECT TEXT FROM ACT_PDC_Dictionary WHERE LanguageCode = @language AND TextCode = 'works') AS [title], 2 AS [order] UNION
			SELECT '/dwsticket' AS [url], 
			--CONCAT((SELECT TEXT FROM ACT_PDC_Dictionary WHERE LanguageCode = @language AND TextCode = 'ticket'), N' - ', (SELECT subject FROM OSCL WHERE callID = @ticketId)) AS [title]
			(SELECT CONCAT(callid, ' - ', docnum) FROM OSCL WHERE callID = @ticketId) AS [title], 3 AS [order]
			ORDER BY [order] ASC;

	END

	IF @resource = 'InventoryData'
	BEGIN

		SELECT 'inventory_data.twig' AS [TemplateFile];
		
		SELECT 'Data' AS [Section];
		SELECT (SELECT TEXT FROM ACT_PDC_Dictionary WHERE LanguageCode = @language AND TextCode = 'warehouse')  AS [form.data.Warehouselabel],
		(SELECT TEXT FROM ACT_PDC_Dictionary WHERE LanguageCode = @language AND TextCode = 'item_code')  AS [form.data.ItemCodelabel],
		(SELECT TEXT FROM ACT_PDC_Dictionary WHERE LanguageCode = @language AND TextCode = 'item_name')  AS [form.data.ItemNamelabel],
		(SELECT TEXT FROM ACT_PDC_Dictionary WHERE LanguageCode = @language AND TextCode = 'quantity')  AS [form.data.Quantitylabel];

		SELECT 'Breadcrumbs' AS [Section];
			SELECT '/' AS [url], (SELECT TEXT FROM ACT_PDC_Dictionary WHERE LanguageCode = @language AND TextCode = 'home') AS [title], 1 AS [order] UNION
			SELECT '/inventorydata' AS [url], (SELECT TEXT FROM ACT_PDC_Dictionary WHERE LanguageCode = @language AND TextCode = 'menu_invertorydata') AS [title], 2 AS [order]
			ORDER BY [order] ASC;

	END

	IF @resource = 'GetItemPrice'
	BEGIN

		SELECT 'item_price.twig' AS [TemplateFile];
		
		SELECT 'Data' AS [Section];
		SELECT (SELECT TEXT FROM ACT_PDC_Dictionary WHERE LanguageCode = @language AND TextCode = 'item_code')  AS [form.data.ItemCodelabel],
			(SELECT TEXT FROM ACT_PDC_Dictionary WHERE LanguageCode = @language AND TextCode = 'price_list')  AS [form.data.PriceListlabel],
			(SELECT TEXT FROM ACT_PDC_Dictionary WHERE LanguageCode = @language AND TextCode = 'card_code')  AS [form.data.Cardcodelabel],
			(SELECT TEXT FROM ACT_PDC_Dictionary WHERE LanguageCode = @language AND TextCode = 'get_price')  AS [form.data.getPricelabel],
			(SELECT TEXT FROM ACT_PDC_Dictionary WHERE LanguageCode = @language AND TextCode = 'item_price')  AS [form.data.ItemPricelabel];

		SELECT 'Breadcrumbs' AS [Section];
			SELECT '/' AS [url], (SELECT TEXT FROM ACT_PDC_Dictionary WHERE LanguageCode = @language AND TextCode = 'home') AS [title], 1 AS [order] UNION
			SELECT '/getitemprice' AS [url], (SELECT TEXT FROM ACT_PDC_Dictionary WHERE LanguageCode = @language AND TextCode = 'menu_itemprice') AS [title], 2 AS [order]
			ORDER BY [order] ASC;

	END

/*
-- #region MyAttendances
	IF @resource = 'MyAttendances'
	BEGIN

		SELECT 'my-attendances.twig' AS [TemplateFile];

		SELECT 'Breadcrumbs' AS [Section];
			SELECT '/' AS [url], N'Főmenü' AS [title], 1 AS [order] UNION
			SELECT '/attendance' AS [url], N'Jelenléti ív' AS [title], 2 AS [order] UNION
			SELECT '/my-attendances' AS [url], N'Jelenléti napló' AS [title], 3 AS [order]
			ORDER BY [order] ASC;

	END
-- #endregion

-- #region Attendance
	IF @resource = 'Attendance'
	BEGIN

		-- DECLARE @example_Id INT = ISNULL((SELECT [Value] FROM @params WHERE [Name] = 'ID'), 0);

		-- DECLARE @example_template NVARCHAR(MAX);
		-- SELECT @example_template = [Data] FROM [@TEMPLATES] WHERE Id = @resource;
		-- SELECT @example_template AS [Template];

		SELECT 'attendance.twig' AS [TemplateFile];

		DECLARE @attendanceCount INT;
		DECLARE @attendance_startDateTime DATETIME;

		SELECT
			@attendanceCount = COUNT(*)
		FROM [@ACTATTENDANCES] WHERE U_ACTEmployeeId = @sess_userId AND U_ACTLeaveDate IS NULL;

		SELECT
			@attendance_startDateTime = CAST((FORMAT(U_ACTEnterDate, 'yyyy-MM-dd')
					+ ' ' + FORMAT(FLOOR(U_ACTEnterTime / 100), '00')
					+ ':' + FORMAT((U_ACTEnterTime % 100), '00')) AS DATETIME)
		FROM [@ACTATTENDANCES]
		WHERE U_ACTEmployeeId = @sess_userId AND U_ACTLeaveDate IS NULL;

		SELECT 'Data' AS [Section];
			SELECT
				(SELECT lastName + ' ' + firstName FROM OHEM WHERE empID = @sess_userId) AS [form.data.Dolgozo],
				FORMAT(@attendance_startDateTime, 'yyyy.MM.dd HH:mm') AS [form.data.Bejelentkezve],
				@attendanceCount [form.data.ActiveAttendanceCount]
			;

		SELECT 'Breadcrumbs' AS [Section];
			SELECT '/' AS [url], N'Főmenü' AS [title], 1 AS [order] UNION
			SELECT '/attendance' AS [url], N'Jelenléti ív' AS [title], 2 AS [order]
			ORDER BY [order] ASC;

	END
-- #endregion
*/
END
GO

