
function DIS_CreateObject {
    param ()
    $node = New-Object -ComObject "SBODI_Server.Node"
    if (-not $node) {
        Write-Error "Failed to create SBODI_Server.Node COM object."
        exit 1
    }
    return $node
}

function DIS_Login {
    param (
        [Parameter(Mandatory = $true)]
        [object]$node,
        [Parameter(Mandatory = $true)]
        [string]$DbServer,
        [Parameter(Mandatory = $true)]
        [string]$CompanyDB,
        [Parameter(Mandatory = $false)]
        [string]$DbType = "dst_MSSQL2019",
        [Parameter(Mandatory = $true)]
        [System.Management.Automation.PSCredential]$DbCredential,
        [Parameter(Mandatory = $true)]
        [System.Management.Automation.PSCredential]$CompanyCredential,
        [Parameter(Mandatory = $false)]
        [string]$LicenseServer = "localhost:30000",
        [Parameter(Mandatory = $false)]
        [string]$Language = "ln_English",
        [Parameter(Mandatory = $false)]
        [bool]$UseTrusted = $false,
        [Parameter(Mandatory = $false)]
        [bool]$ShowDetails = $false
    )

    $dbUsername = $DbCredential.UserName
    $dbPasswordPlain = [Runtime.InteropServices.Marshal]::PtrToStringAuto(
        [Runtime.InteropServices.Marshal]::SecureStringToBSTR($DbCredential.Password)
    )

    $companyUsername = $CompanyCredential.UserName
    $companyPasswordPlain = [Runtime.InteropServices.Marshal]::PtrToStringAuto(
        [Runtime.InteropServices.Marshal]::SecureStringToBSTR($CompanyCredential.Password)
    )

    $result = DIS_Send -node $node -Body "
<dis:Login xmlns:dis=""http://www.sap.com/SBO/DIS"">
    <DatabaseServer>$DbServer</DatabaseServer>
    <DatabaseName>$CompanyDB</DatabaseName>
    <DatabaseType>$DbType</DatabaseType>
    <DatabaseUsername>$dbUsername</DatabaseUsername>
    <DatabasePassword>$dbPasswordPlain</DatabasePassword>
    <CompanyUsername>$companyUsername</CompanyUsername>
    <CompanyPassword>$companyPasswordPlain</CompanyPassword>
    <Language>$Language</Language>
    <LicenseServer>$LicenseServer</LicenseServer>
    <UseTrusted>$($UseTrusted.ToString().ToLower())</UseTrusted>
</dis:Login>
" -ShowDetails $ShowDetails

    if ($result -match "<SessionID>(.+?)</SessionID>") {
        $SessionID = $matches[1]
    } else {
        throw "Login failed. Result: $result"
    }
    return $SessionID
}

function DIS_Logout {
    param (
        [Parameter(Mandatory = $true)]
        [object]$node,
        [Parameter(Mandatory = $true)]
        [string]$SessionID,
        [Parameter(Mandatory = $false)]
        [bool]$ShowDetails = $false
    )
    return DIS_Send -node $node -SessionID $SessionID -Body "<dis:Logout xmlns:dis=""http://www.sap.com/SBO/DIS"" />" -ShowDetails $ShowDetails
}

function DIS_Send {
    param (
        [Parameter(Mandatory = $true)]
        [object]$node,
        [Parameter(Mandatory = $true)]
        [string]$Body,
        [Parameter(Mandatory = $false)]
        [string]$SessionID = $null,
        [Parameter(Mandatory = $false)]
        [bool]$ShowDetails = $false
    )
    if ($SessionID -ne $null -and $SessionID -ne "") {
        $SessionIDHeader = "<dis:SessionID xmlns:dis=""http://www.sap.com/SBO/DIS"">$SessionID</dis:SessionID>"
    } else {
        $SessionIDHeader = ""
    }
    $xml = @"
<?xml version="1.0" encoding="UTF-8"?>
<env:Envelope xmlns:env="http://schemas.xmlsoap.org/soap/envelope/">
    <env:Header>$SessionIDHeader</env:Header>
    <env:Body>$Body</env:Body>
</env:Envelope>
"@
    if ($ShowDetails) {
        Write-Host ">>> Sending XML message:`n===`n$xml`n===`n"
    }

    return $node.Interact($xml)
}